#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${EXEC_HOME}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
root_info=$1
root_info=$(perl -e 'print quotemeta shift(@ARGV)' -- "${root_info}")
master_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../scripts/pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('0'))"`
slave_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../scripts/pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('1'))"`
function main()
{
    # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS=$(python ${EXEC_HOME}/../scripts/pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}" | tee -a ${log_file}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed" | tee -a ${log_file}
        exit 1
    fi
    # Euler2.9后ICMR升级前需要删除/root/.gnupg/secring.gpg
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        expect <<EOF
            set timeout 60
            spawn ssh ossadm@${ip}
            expect {
                ">" { send "su - root\n";}
                "~]" { send "su - root\n";}
            }
            expect "Password:" { send -- "${root_info}\n" }
            expect "#" { send "mkdir -p /opt/os_patch/backup\n" }
            expect "#" { send "\[\[ -f /root/.gnupg/secring.gpg \]\] && cp /root/.gnupg/secring.gpg /opt/os_patch/backup\n" }
            expect "#" { send "rm -f  /root/.gnupg/secring.gpg\n" }
            expect "#" { send "exit\n" } expect eof
EOF
wait
    done

    expect <<EOF
        set timeout 60
        spawn ssh ossadm@${master_ip}
        expect {
            ">" { send "su - root\n";}
            "~]" { send "su - root\n";}
        }
        expect "Password:"
        send -- "$root_info\r"
        expect "#"
        send "cp -rf ${EXEC_HOME}/logicrep/* /opt/install\r"
        expect "#"
        send "cd /opt/install/\r"
        expect "#"
        send "chown -R root:root /opt/install/\r"
        expect "#"
        send "chown ossadm:ossgroup /opt/install/\r"
        expect "#"
        send "bash logic_tool_kill.sh\r"
        expect "#"
        send "bash logic_tool_backup.sh\r"
        expect "#"
        send "bash logic_tool_copy_log.sh\r"
        expect "#"
        send "rm -rf /opt/zenith/app/admin/plugin/logicrep/*\r"
        expect "yes/no" {send "yes\r"}
        expect "#" { send "exit\r" } expect eof
EOF
wait
    
    
    if [ -n "$slave_ip" ];then
        ssh -o StrictHostKeyChecking=no ossadm@${slave_ip} rm -rf /opt/oss/logicrep
        scp -r $EXEC_HOME/logicrep ossadm@[$slave_ip]:/opt/oss
        expect <<EOF
        set timeout 60
        spawn ssh ossadm@${slave_ip}
        expect {
            ">" { send "su - root\n";}
            "~]" { send "su - root\n";}
        }
        expect "Password:"
        send -- "$root_info\r"
        expect "#"
        send "rm -rf /opt/install/*\r"
        expect "#"
        send "cp -rf /opt/oss/logicrep/* /opt/install/\r"
        expect "#"
        send "cd /opt/install/\r"
        expect "#"
        send "chown -R root:root /opt/install/\r"
        expect "#"
        send "chown ossadm:ossgroup /opt/install/\r"
        expect "#"
        send "bash logic_tool_kill.sh\r"
        expect "#"
        send "bash logic_tool_backup.sh\r"
        expect "#"
        send "bash logic_tool_copy_log.sh\r"
        expect "#"
        send "rm -rf /opt/zenith/app/admin/plugin/logicrep/*\r"
        expect "yes/no" {send "yes\r"}
        expect "#" { send "exit\r" } expect eof
EOF
wait
    fi
}

main >> ${log_file} 2>&1
