import subprocess
from datetime import datetime
import os
import sys
sys.path.append(os.path.split(os.path.abspath(__file__))[0])
import set_log
import version_to_number
from func.upgrade.upgrade_operation_mgr.dao.upgrade_childtask_dao import UpgradeChildTaskDao


def exe(kvs):
    modify_dict = {'remain_time': '0', 'progress': '100', 'status': 'finish'}
    cur_path = os.path.split(__file__)[0]
    cur_file_name = os.path.split(__file__)[1]
    get_log_shell = os.path.join(cur_path, "..", "scripts", "get_log_dir.sh")
    _, log_dir = subprocess.getstatusoutput("sh %s" % get_log_shell)
    my_log = set_log.set_log(filename=os.path.join(log_dir, "%s.log" % cur_file_name))
    easysuite_upgrade_params = kvs.get('easysuite_upgrade_params')
    task_id = easysuite_upgrade_params.get('task_id')
    sub_task_id = easysuite_upgrade_params.get('sub_task_id')
    child_task_id = easysuite_upgrade_params.get('child_task_id')
    result = 1
    start_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
    msg = "[%s] Start rollback logicrep" % start_time
    try:
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg, 'status': 'running'})
        src_version = easysuite_upgrade_params.get("product_version")
        src_version_number = version_to_number.version_to_number(src_version)
        my_log.info("src_version: %s, src_version_number: %s" % (
            src_version, src_version_number))
        # 22.0版本以后逻辑复制工具不需要回滚
        if src_version_number >= 22.0:
            result = 0
        else:
            root_pwd = easysuite_upgrade_params.get('adminpwd')

            command = "sh %s %s" % (
                os.path.join(cur_path, "logic_tool_rollback.sh"), root_pwd)
            result = subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
    except:
        my_log.exception("Excepion logged")
    if result != 0:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Rollback_logicrep error" % end_time
        modify_dict["status"] = "error"
        modify_dict["msg"] = msg
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, modify_dict)
        return False
    else:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Rollback_logicrep SUCCESS." % end_time
        modify_dict["msg"] = msg
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, modify_dict)
        return True

