#!/bin/bash

CUR_PATH=$(cd "$(dirname "$0")"; pwd)
script_name=`basename $0`

print_log()
{
    local content=$*
    log_filename="$CUR_PATH/update_nw.log"
    echo $log_filename 
    CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
    echo "Log: $CURTIME $$ $script_name : $content" | tee -a $log_filename
}

#获取数据库信息（query database)
get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`

    if [ -z "$dbinfo" ]
    then
        print_log "$LINENO single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
        db_type=`echo $dbinfo|awk '{print $9}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Slave|awk '{print $3}'`
        db_type=`echo $dbinfo|awk '{print $9}'`
    fi

    
}


main(){
    
    instance_name=dcnnwcommondb
    instance_db_name="dcnlogicrepdb"
    #运行函数：获取数据库ip,port, admin password
    get_dbip_port $instance_name

    # get_sys_info
    sys_info=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../../scripts/pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main_sys('${instance_name}', 'zenith'))" 2>&1`
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get sys_info successfully."
        result_array_sys=(${sys_info//,/ })
        sys_user=${result_array_sys[0]}
        sys_pp=${result_array_sys[1]}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get sys_info failed."
        exit 1
    fi

    # get_db_info
    db_info=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../../scripts/pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${instance_name}', '${instance_db_name}', 'zenith'))" 2>&1`
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully."
        result_array=(${db_info//,/ })
        adminPP=${result_array[2]}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
        exit 1
    fi

    if [ -z "$adminPP" ]
    then
        print_log "$LINENO $instance_db_name acquire DB passwd failed,exit"
        exit 1
    else
        print_log "$LINENO $instance_db_name acquire DB passwd success "
    fi

    # 4. 执行sql
    sudo -s -u dbuser<<EOF
    export LD_LIBRARY_PATH=/opt/zenith/app/add-ons:/opt/zenith/app/lib:/opt/oss/envs/DBAgent/service/dbdriver_zenith/pyscript/zenith:/opt/oss/manager/agent/DeployAgent/dbdriver_zenith/pyscript/zenith:/opt/oss/manager/agent/DeployAgent/dbdriver_mysql/pyscript/mysql:/opt/oss/manager/agent/DeployAgent/dbdriver_gauss/pyscript/gauss:/opt/oss/manager/agent/DeployAgent/rtsp/python/lib:/usr/local/lib:/usr/lib:/lib
    export PATH=/opt/zenith/app/bin:/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/osconfig/os/bin:/opt/oss/manager/agent/DeployAgent/rtsp/python/bin:/usr/local/bin:/usr/bin:/bin:/opt/oss/manager/agent/DeployAgent/bin:/opt/oss/manager/bin:/sbin:/usr/local/sbin:/usr/sbin:/home/ossadm/.local/bin:/home/ossadm/bin
    export GSDB_HOME=/opt/zenith/app
    /opt/zenith/app/bin/zsql ${sys_user}/${sys_pp}@${MACHINE_IP}:${port} -c "GRANT ALTER DATABASE TO dcnlogicrepdb;"
EOF

    sudo -s -u dbuser<<EOF
    export LD_LIBRARY_PATH=/opt/zenith/app/add-ons:/opt/zenith/app/lib:/opt/oss/envs/DBAgent/service/dbdriver_zenith/pyscript/zenith:/opt/oss/manager/agent/DeployAgent/dbdriver_zenith/pyscript/zenith:/opt/oss/manager/agent/DeployAgent/dbdriver_mysql/pyscript/mysql:/opt/oss/manager/agent/DeployAgent/dbdriver_gauss/pyscript/gauss:/opt/oss/manager/agent/DeployAgent/rtsp/python/lib:/usr/local/lib:/usr/lib:/lib
    export PATH=/opt/zenith/app/bin:/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/osconfig/os/bin:/opt/oss/manager/agent/DeployAgent/rtsp/python/bin:/usr/local/bin:/usr/bin:/bin:/opt/oss/manager/agent/DeployAgent/bin:/opt/oss/manager/bin:/sbin:/usr/local/sbin:/usr/sbin:/home/ossadm/.local/bin:/home/ossadm/bin
    export GSDB_HOME=/opt/zenith/app
    /opt/zenith/app/bin/zsql $instance_db_name/${adminPP}@${MACHINE_IP}:${port} -c "ALTER DATABASE ENABLE_LOGIC_REPLICATION ON;"
EOF
    
}
main

