import subprocess
from datetime import datetime
import os
import json
import sys
sys.path.append(os.path.split(os.path.abspath(__file__))[0])
import set_log
import version_to_number
from func.upgrade.upgrade_operation_mgr.dao.upgrade_childtask_dao import UpgradeChildTaskDao


def exe(kvs):
    modify_dict = {'remain_time': '0', 'progress': '100', 'status': 'finish'}
    cur_path = os.path.split(__file__)[0]
    cur_file_name = os.path.split(__file__)[1]
    get_log_shell = os.path.join(cur_path, "..", "scripts", "get_log_dir.sh")
    _, log_dir = subprocess.getstatusoutput("sh %s" % get_log_shell)
    my_log = set_log.set_log(filename=os.path.join(log_dir, "%s.log" % cur_file_name))
    easysuite_upgrade_params = kvs.get('easysuite_upgrade_params')
    task_id = easysuite_upgrade_params.get('task_id')
    sub_task_id = easysuite_upgrade_params.get('sub_task_id')
    child_task_id = easysuite_upgrade_params.get('child_task_id')
    simple_kvs = easysuite_upgrade_params.get('simple_kvs')
    standby_ip = simple_kvs.get('standby').get('0').get('ip')
    standby_ip_pwd = simple_kvs.get('standby').get('0').get('ossadm')
    sopuser_pwd = simple_kvs.get('standby').get('0').get('sopuser')
    result = 1
    start_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
    msg = "[%s] Start stop logicrep" % start_time
    try:
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        src_version = easysuite_upgrade_params.get("product_version")
        src_version_number = version_to_number.version_to_number(src_version)
        is_upgrade_os = kvs.get('upgrade_item')
        my_log.info("src_version: %s, src_version_number: %s, is_upgrade_os: %s" % (
            src_version, src_version_number, is_upgrade_os))
        upgrade_step = "before"
        is_upgrade = False
        if "params" in easysuite_upgrade_params:
            params = json.loads(easysuite_upgrade_params["params"])
            if params["type"] == "upgrade":
                is_upgrade = True
        my_log.info("is_upgrade: %s" % is_upgrade)
        root_pwd = easysuite_upgrade_params.get('adminpwd')
        if is_upgrade:
            if src_version_number >= 22.0:
                step_shell_name = "logic_tool_stop"
            else:
                step_shell_name = "logic_tool_copy"
            command = "sh %s %s %s %s %s %s %s" % (os.path.join(cur_path, "ssh_exec.sh"),
                                                   upgrade_step, standby_ip, standby_ip_pwd,
                                                   sopuser_pwd, step_shell_name, root_pwd)
            result = subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
            # 判断是否升级os
            if "id_upgrade_os" in is_upgrade_os:
                command = "sh %s %s %s %s %s %s %s" % (
                    os.path.join(cur_path, "ssh_exec.sh"), "after", standby_ip, standby_ip_pwd, sopuser_pwd,
                    "handle_buildin_pkg_flag", root_pwd)
                result1 = subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
                if result1 != 0:
                    end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
                    msg = msg + '\n' + "[%s] handle buildin pkg flag error" % end_time
                    modify_dict["status"] = "error"
                    modify_dict["msg"] = msg
                    UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, modify_dict)
                    return False
        else:
            upgrade_step = "after"
            if src_version_number == 20.0:
                my_log.info("src_version: %s, need delete old instance" % src_version)
                command = "sh %s %s %s %s %s %s %s" % (
                    os.path.join(cur_path, "ssh_exec.sh"), "after", standby_ip, standby_ip_pwd, sopuser_pwd,
                    "delete_old_instance", root_pwd)
                result1 = subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
                if result1 != 0:
                    end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
                    msg = msg + '\n' + "[%s] delete old instance error" % end_time
                    modify_dict["status"] = "error"
                    modify_dict["msg"] = msg
                    UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, modify_dict)
                    return False
            command = "sh %s %s %s %s %s %s %s" % (os.path.join(cur_path, "ssh_exec.sh"),
                                                   upgrade_step, standby_ip, standby_ip_pwd,
                                                   sopuser_pwd, "logic_tool_stop", root_pwd)
            result = subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
    except:
        my_log.exception("Excepion logged")
    if result != 0:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Stop logicrep error" % end_time
        modify_dict["status"] = "error"
        modify_dict["msg"] = msg
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, modify_dict)
        return False
    else:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Stop logicrep SUCCESS." % end_time
        modify_dict["msg"] = msg
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, modify_dict)
        return True

