#!/bin/bash

# 升级前删除逻辑复制工具相关进程，否则备份管理面会失败
function kill_logic_process()
{
    grep_content=${1}
    user=${2}
    all_id=$(ps -ef | grep -v grep | grep "${grep_content}" | grep ${user} | awk '{print $2}')
    if [[ -n ${all_id} ]]
    then
        for id in ${all_id}
        do
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "kill ${grep_content} id: ${id}"
            kill -9 "${id}"
        done
    fi
}

kill_logic_process "logic_tool_start.sh" ossuser
kill_logic_process "logicrep" root

if [[ -f "/opt/zenith/app/admin/plugin/logicrep/shutdown.sh" ]]; then
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "Stop the logicrep tool process."
    su - dbuser -c 'bash /opt/zenith/app/admin/plugin/logicrep/watchdog_shutdown.sh -n logicrep'
    su - dbuser -c 'bash /opt/zenith/app/admin/plugin/logicrep/shutdown.sh -n logicrep'
fi
kill_logic_process "logicrep" dbuser





