#!/bin/bash

rm -rf /opt/software/start_logicrep.log
while true
do
  if [ -f "/opt/software/logicrep_install.py" ]; then
    echo "$NOWTIME: compileall logicrep script" >> /opt/software/start_logicrep.log
    sleep 3

    /opt/software/python/bin/python -m compileall -b /opt/software/logicrep_install.py
    rm -rf /opt/software/logicrep_install.py
  fi

  NOWTIME=$(date +%Y%m%d_%H%M%S)
  DB_STATUS=$(netstat -anp | grep :"$2" | grep LISTEN | wc -l)
  DTAGENT_STATUS=$(ps -ef | grep org.apache.catalina.startup | grep DTAgent | grep -v grep | wc -l)
  flag=0
  if [ $DB_STATUS -le 0 ]||[ $DTAGENT_STATUS -le 0 ]; then
    flag=1
  fi

  while [ $DB_STATUS -le 0 ]||[ $DTAGENT_STATUS -le 0 ]
  do
    NOWTIME=$(date +%Y%m%d_%H%M%S)
    DB_STATUS=$(netstat -anp | grep :"$2" | grep LISTEN |wc -l)
    DTAGENT_STATUS=$(ps -ef | grep org.apache.catalina.startup | grep DTAgent | grep -v grep | wc -l)

    if [ $DTAGENT_STATUS -le 0 ];then
      echo "$NOWTIME: Waiting for the DTAgent to start" >> /opt/software/start_logicrep.log
    fi
    if [ $DB_STATUS -le 0 ];then
      echo "$NOWTIME: Waiting for the database to start" >> /opt/software/start_logicrep.log
    fi
    sleep 1
  done

  if [ $flag -eq 1 ]; then
    NOWTIME=$(date +%Y%m%d_%H%M%S)
    echo "$NOWTIME: The database and DTAgent has been started." >> /opt/software/start_logicrep.log
    echo "$NOWTIME: start logicrep" >> /opt/software/start_logicrep.log

    if [ -f "/opt/zenith/app/admin/plugin/logicrep/shutdown.sh" ]; then
      echo "$NOWTIME: Stop the logicrep tool process." >> /opt/software/start_logicrep.log
      su - dbuser -c 'nohup bash /opt/zenith/app/admin/plugin/logicrep/watchdog_shutdown.sh -n logicrep > /dev/null 2>&1'
      su - dbuser -c 'nohup bash /opt/zenith/app/admin/plugin/logicrep/shutdown.sh -n logicrep > /dev/null 2>&1'
      sleep 10
      ps -aux | grep logicrep | grep -v 'grep' | grep -v 'start_logicrep' | awk '{print $2}' | xargs kill -9 > /dev/null 2>&1
    fi

    /opt/software/python/bin/python /opt/software/logicrep_install.py* "$1"
    sleep 10
  fi

  if [ $flag -ne 1 ]; then
    logicrep=$(ps -ef | grep logicrep.ZLogCatcherMain | grep -v grep | wc -l)
    if [ $logicrep -lt 1 ]; then
      echo "$NOWTIME: logicrep is stopped, Restarting" >> /opt/software/start_logicrep.log
      /opt/software/python/bin/python /opt/software/logicrep_install.py* "$1"
      sleep 10
    fi
  fi
done
