#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${CUR_PATH}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
temporary_dir=$(sh ${CUR_PATH}/../scripts/get_temporary_dir.sh)
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}

function main()
{
    if [ -f ${temporary_dir}/os_result_after_rollback.flag ]
    then
        rm -rf ${temporary_dir}/os_result_after_rollback.flag
    fi

    query_os_src=${log_dir}/query_os_src.txt
    if [[ ! -f ${query_os_src} ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "file name ${query_os_src} dose not exists"
    fi

    # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS=$(python ${CUR_PATH}/../scripts/pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}" | tee -a ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed" | tee -a ${log_file}
            exit 1
    fi

    #创建结果文件夹
    result_set="${temporary_dir}/query_os_after_rollback_all"
    rm -rf ${result_set}
    mkdir -p ${result_set}

    #验证os
    IPS_array=(${IPS//,/ })


    #判断X86或ARM
    is_suse=$(cat /etc/*release |grep SUSE | wc -l)
    if [[ ${is_suse} -ge 1 ]]
    then
        os_type=$(cat ${log_dir}/query_os_src.txt)
    else
        os_type_version=$(cat ${log_dir}/query_os_src.txt)
        os_type=$(${PYTHONHOME}/bin/python -c "import re;print(re.findall('v\d+r\d+', '${os_type_version}')[0])")
        if [[ $? == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get os_type successfully: ${os_type}"
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get os_type failed"
                exit 1
        fi
    fi

    if [[ -z ${os_type} ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "os_type is empty"
        exit 1
    fi

    #获取ompip
    result_set_ip="${temporary_dir}/query_os_after_rollback_ip"
    ompip=${IPS_array[0]//:9094/}
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh ossadm@${ip} << EOF
            rm -rf ${result_set_ip}
            mkdir -p ${result_set_ip}
            exit
EOF
        expect <<EOF
        set timeout -1
        spawn ssh ossadm@${ip}
        expect {
            ">" { send "cat /etc/*release | grep ${os_type} > ${result_set_ip}/osresult_${ip}.txt\n";}
            "~]" { send "uname -r | grep ${os_type} > ${result_set_ip}/osresult_${ip}.txt\n";}
        }
        expect {
            "~]" {send "exit\n";expect eof}
            ">" {send "exit\n";expect eof}
        }
EOF
wait
    done

    #将结果取回omp
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        scp ossadm@\[$ip\]:${result_set_ip}/osresult_${ip}.txt ${result_set}
        ssh -o StrictHostKeyChecking=no ossadm@${ip} rm -rf ${result_set_ip}/osresult_${ip}.txt
    done


    for file in ${result_set}/*;do
        if [[ -s $file ]]
        then
            echo "successful" > ${temporary_dir}/os_result_after_rollback.flag
        else
            echo "$file failed" > ${temporary_dir}/os_result_after_rollback.flag
            break
        fi
    done

}

main >> ${log_file} 2>&1
