import time
import os
import subprocess
import sys
from datetime import datetime
sys.path.append(os.path.split(os.path.abspath(__file__))[0])
import get_temporary_path
from func.upgrade.upgrade_operation_mgr.dao.upgrade_childtask_dao import UpgradeChildTaskDao

def exe(kvs):
    temporary_path = get_temporary_path.get_temporary_path()
    cur_path = os.path.split(__file__)[0]
    easysuite_upgrade_params = kvs.get('easysuite_upgrade_params')
    task_id = easysuite_upgrade_params.get('task_id')
    sub_task_id = easysuite_upgrade_params.get('sub_task_id')
    child_task_id = easysuite_upgrade_params.get('child_task_id')
    start_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
    msg = "[%s] Start query os after upgrade" % start_time
    UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg, 'status': 'running'})
    command = "sh %s" % (
        os.path.join(cur_path, "query_os_des.sh"))
    subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
    flag_path = os.path.join(temporary_path, "os_result_des.flag")
    if os.path.exists(flag_path):
        with open(flag_path, 'r') as f:
            if "failed" in f.read():
                result = 1
            else:
                result = 0
    else:
        result = 1
    if result != 0:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Query os after upgrade failed" % end_time
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'remain_time': '0'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'progress': '100'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'error'})
        print(UpgradeChildTaskDao.query(task_id, sub_task_id, child_task_id))
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        return False
    else:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Query os after upgrade successfully" % end_time
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'remain_time': '0'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'progress': '100'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'finish'})
        print(UpgradeChildTaskDao.query(task_id, sub_task_id, child_task_id))
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        return True