#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${CUR_PATH}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
temporary_dir=$(sh ${CUR_PATH}/../scripts/get_temporary_dir.sh)
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}


function main()
{
    if [ -f ${temporary_dir}/os_result_des.flag ]
    then
        rm -rf ${temporary_dir}/os_result_des.flag
    fi

    # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS=$(python ${CUR_PATH}/../scripts/pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}" | tee -a ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed" | tee -a ${log_file}
            exit 1
    fi

   # 删除包管理标志文件
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh ossadm@${ip} << EOF
            echo "delete handle_buildin_pkg_flag in $ip"
            sudo -u ossuser rm -rf /tmp/handle_buildin_pkg_flag
            exit
EOF
    done

    #创建结果文件夹
    result_set="${temporary_dir}/query_os_des_all"
    rm -rf ${result_set}
    mkdir -p ${result_set}

    #验证os
    result_set_ip="${temporary_dir}/query_os_des_ip"
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh ossadm@${ip} << EOF
            rm -rf ${result_set_ip}
            mkdir -p ${result_set_ip}
            exit
EOF
        expect <<EOF
        set timeout -1
        spawn ssh ossadm@${ip}
        expect {
            ">" { send "cat /etc/*release | grep 12-SP5 > ${result_set_ip}/osresult_${ip}.txt\n";}
            "~]" { send "uname -r | grep 'v2r10' > ${result_set_ip}/osresult_${ip}.txt\n";}
        }
        expect {
            "~]" {send "exit\n";expect eof}
            ">" {send "exit\n";expect eof}
        }
EOF
wait
    done

    #将结果取回omp
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        scp ossadm@\[$ip\]:${result_set_ip}/osresult_${ip}.txt ${result_set}
        ssh -o StrictHostKeyChecking=no ossadm@${ip} rm -rf ${result_set_ip}/osresult_${ip}.txt
    done


    for file in ${result_set}/*;do
        if [[ -s $file ]]
        then
            echo "successful" > ${temporary_dir}/os_result_des.flag
        else
            echo "$file failed" > ${temporary_dir}/os_result_des.flag
            break
        fi
    done

    #升级后检查包管理
    if [ -f ${temporary_dir}/package_status.flag ]
    then
        rm -rf ${temporary_dir}/package_status.flag
    fi
    cd ${CUR_PATH}/../scripts/pyscripts/
    result_status=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../scripts/pyscripts/');import check_package_status;print(check_package_status.main('${log_dir}'))")
    if [[ $? == "0" ]]
    then
        if [[ ${result_status} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the package status is ok."
            echo "successful" > ${temporary_dir}/package_status.flag
        elif [[ ${result_status} == "1" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "the package status is not ok."
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "check package status failed."
        fi
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "check package status failed."
    fi

    #恢复倒换
    /opt/oss/manager/apps/CloudbMgmtService/bin/switchtool.sh -cmd del-ignore-nodes

}

main >> ${log_file} 2>&1
