#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${CUR_PATH}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}

function main()
{
     # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS=$(python ${CUR_PATH}/../scripts/pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}" | tee -a ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed" | tee -a ${log_file}
            exit 1
    fi

    #升级前版本
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh -o StrictHostKeyChecking=no ossadm@${ip} << EOF
            [[ ! -d ${log_dir} ]] && mkdir -p ${log_dir}
            rm -rf ${log_dir}/query_os_src.txt
            uname -r > ${log_dir}/query_os_src.txt
            if [ $? -ne 0 ];then
                echo "`date '+%Y-%m-%d %H:%M:%S'` [ERROR] Query os failed"
                exit 1
            fi
        exit
EOF
    done

}

main >> ${log_file} 2>&1
