#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
upgrade_step=${1}
self_name="${0##*/}"
log_dir=`sh ${CUR_PATH}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
temporary_dir=$(sh ${CUR_PATH}/../scripts/get_temporary_dir.sh)
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}
master_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${CUR_PATH}/../scripts/pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('0'))"`


function main()
{
    upgrade_sudo_pkg=upgrade_sudo_pkg.tar

    if [[ ${upgrade_step} == "upgrade" ]]
    then
        # 升级/回退 os的结果文件
        os_upgrade_online_result_dir=${temporary_dir}/os_upgrade_online_result
        # os是否重启过的标记文件
        os_online_reboot_flag=${temporary_dir}/os_online_reboot_for_upgrade.flag
    elif [[ ${upgrade_step} == "rollback" ]]
    then
        # 升级/回退 os的结果文件
        os_upgrade_online_result_dir=${temporary_dir}/os_rollback_online_result
        # os是否重启过的标记文件
        os_online_reboot_flag=${temporary_dir}/os_online_reboot_for_rollback.flag
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "param is must be upgrade or rollback, param: ${upgrade_step}"
        exit 1
    fi

    if [[ ! -d  ${os_upgrade_online_result_dir} ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "${os_upgrade_online_result_dir} dose not exists"
        exit 1
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${os_upgrade_online_result_dir}  exists"
    fi

    # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS_UN_ORDER=$(python ${CUR_PATH}/../scripts/pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS_UN_ORDER successfully: ${IPS_UN_ORDER}"
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS_UN_ORDER failed"
            exit 1
    fi

    # 排序
    IPS=`${PYTHONHOME}/bin/python -c "ip_list=[ip for ip in '${IPS_UN_ORDER}'.split(',') if '${master_ip}' != ip.rsplit(':', 1)[0]];ip_list.append('${master_ip}'+':9094');print(','.join(ip_list))"`
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "sort ips successfully: ${IPS}"
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "sort ips failed"
            exit 1
    fi

    # 获取需要重启的IP
    restart_ips=${IPS}
    for file in ${os_upgrade_online_result_dir}/*;do
        ip=`${PYTHONHOME}/bin/python -c "print('$file'.split('.txt')[0].split('_')[-1])"`
        if [[ ${result} == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get ip successfully: ${ip}"
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get ip failed"
                exit 1
        fi

        # 判断文件内容
        if [[ ! -z $(cat $file | grep "success install") ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${file} result is [success install], ${ip} need restart"
        elif [[ ! -z $(cat $file | grep "success skip") ]]
        then
            # 不需要重启的ip去除掉
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${file} result is [success skip], ${ip} skip restart"
            restart_ips=`${PYTHONHOME}/bin/python -c "ip_list=[ip for ip in '${restart_ips}'.split(',') if '${ip}' != ip.rsplit(':', 1)[0]];print(','.join(ip_list))"`
            if [[ $? == "0" ]]
                then
                    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "deal restart_ips successfully: ${restart_ips}"
                else
                    echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "deal restart_ips failed"
                    exit 1
            fi
        else
            file_content=$(cat $file)
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "invalid content: ${file} content is ${file_content}"
            exit 1
        fi
    done

    # 需要重启的IP为空, 直接退出
    if [[ -z  ${restart_ips} ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "all nodes do not need restart"
        exit 0
    fi

    # 判断已重启的ip
    IPS_array=(${restart_ips//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        reboot_ip=${ip_port_array[0]}
        ssh -o StrictHostKeyChecking=no ossadm@${reboot_ip} ls ${os_online_reboot_flag}
        if [[ $? == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${reboot_ip} has reboot, skip"
                restart_ips=`${PYTHONHOME}/bin/python -c "ip_list=[ip for ip in '${restart_ips}'.split(',') if '${reboot_ip}' != ip.rsplit(':', 1)[0]];print(','.join(ip_list))"`
                if [[ $? == "0" ]]
                    then
                        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "deal restart_ips successfully: ${restart_ips}"
                    else
                        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "deal restart_ips failed"
                        exit 1
                fi
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${ip} need reboot"
        fi
    done


    # 需要重启的IP为空, 直接退出
    if [[ -z  ${restart_ips} ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "all nodes do not need restart"
        exit 0
    fi

    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start restart"
    IPS_array=(${restart_ips//,/ })
    for ip_port in ${IPS_array[@]}
    do
        {
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh -o ServerAliveInterval=60 ossadm@${ip} <<EOF
            sudo ${SUPER_ROOT}/execute.sh ${temporary_dir}/${upgrade_sudo_pkg} ${temporary_dir}/reboot reboot_os.sh ${os_online_reboot_flag}
            exit
EOF
        if [[ $? -ne 0 ]];then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "exec reboot_os.sh failed"
            exit 1
        fi
        }
    done
    wait
}

main >> ${log_file} 2>&1
