#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
root_pwd=$1
root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' -- "${root_pwd}")
self_name="${0##*/}"
log_dir=`sh ${CUR_PATH}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}

function main()
{
     # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS=$(python ${CUR_PATH}/../scripts/pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}"
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed"
            exit 1
    fi


    #回滚os
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        {
        ip_port_array=(${ip_port//:/ })
        ip=${ip_port_array[0]}
        expect <<EOF
            set timeout -1
            spawn ssh ossadm@${ip}
            expect {
                ">" { send "su - root\n";}
                "~]" { send "su - root\n";}
            }
            expect "Password:" { send -- "${root_pwd}\n" }
            expect "#" { send "\[\[ -f /opt/os_patch/backup/secring.gpg \]\] && cp /opt/os_patch/backup/secring.gpg /root/.gnupg\n" }
            expect "#" { send "\[\[ '' -eq '`lsattr -d /usr/bin | grep "\-i"`' \]\] && systemctl restart lock\n" }
            expect "#" { send "sleep 10\n" }
            expect "#" { send "systemctl stop lock\n" }
            expect "#" { send "grubby --set-default=/boot/vmlinuz-upgrade\n" }
            expect "#" { send "sync;sync;sync;sync;shutdown -r +1\n" }
            expect "#" { send "exit\n" } expect eof
EOF
wait
        }&
    done
}

main >> ${log_file} 2>&1
