#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${EXEC_HOME}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
#接收参数
upgrade_step=$1
standby_ip=$2
# ossadm用户的
standby_ip_pwd=$3
standby_ip_pwd=$(perl -e 'print quotemeta shift(@ARGV)' -- "${standby_ip_pwd}")
sopuser_pwd=$4
sopuser_pwd=$(perl -e 'print quotemeta shift(@ARGV)' -- "${sopuser_pwd}")
step_name=$5
root_pwd=$6
root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' -- "${root_pwd}")
os_pkg_tar=$7
os_pkg_gz=$8
os_pkg_patch=$9
scripts_path="/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric/upgrade_online"
service_path="/opt/upgrade"
echo $(date '+%Y-%m-%d %H:%M:%S') [INFO] "log_file name is ${log_file}" >> ${log_file}
echo $(date '+%Y-%m-%d %H:%M:%S') [INFO] "params name is upgrade_step: ${upgrade_step}, standby_ip: ${standby_ip},
step_name: ${step_name}, os_pkg_tar: ${os_pkg_tar}, os_pkg_gz: ${os_pkg_gz}, os_pkg_patch: ${os_pkg_patch}" >> ${log_file}


function main()
{
    id sopuser
    if [[ $? != "0" ]]
    then
        echo $(date '+%Y-%m-%d %H:%M:%S') [INFO] "the environment does not contain the sopuser user"
        ssh_user_for_after=ossadm
        ssh_pwd_for_after=${standby_ip_pwd}
    else
        echo $(date '+%Y-%m-%d %H:%M:%S') [INFO] "the environment contains the sopuser user"
        ssh_user_for_after=sopuser
        ssh_pwd_for_after=${sopuser_pwd}
    fi

    #脚本拷贝到备站点并添加白名单
    if [[ ${upgrade_step} == "before" ]]
    then
        . /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../scripts/pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('0'))" > ${service_path}/service/master_ip.txt
        . /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../scripts/pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('1'))" > ${service_path}/service/slave_ip.txt
        expect <<EOF
        set timeout -1
        spawn ssh ossadm@${standby_ip}
        expect {
            "password" {send -- "${standby_ip_pwd}\n";}
            "~]" {send "\n";}
            ">" {send "\n";}
            "yes/no" {send "yes\n";exp_continue}
        }
        expect {
            ">" { send "rm -rf ${scripts_path}\n";}
            "~]" { send "rm -rf ${scripts_path}\n";}
        }
        expect {
            "~]" {send "\n";}
            ">" {send "\n";}
            "yes/no" {send "yes\n";exp_continue}
        }
        expect {
            ">" { send "mkdir -p ${scripts_path}\n";}
            "~]" { send "mkdir -p ${scripts_path}\n";}
        }
        expect {
            "~]" {send "exit\n";expect eof}
            ">" {send "exit\n";expect eof}
        }
EOF
    wait
        expect <<EOF
        set timeout -1
        spawn scp -r ${service_path}/service ossadm@\[$standby_ip\]:${scripts_path}/
        expect {
            "password" {send -- "${standby_ip_pwd}\n";}
            "~]" {send "\n";}
            ">" {send "\n";}
            "yes/no" {send "yes\n";exp_continue}
        }
        expect {
            "~]" {send "exit\n";expect eof}
            ">" {send "exit\n";expect eof}
        }
EOF
    wait
    expect <<EOF
        set timeout -1
        spawn su - root
        expect "Password:" { send -- "${root_pwd}\n" }
        expect "#" { send "bash /opt/SEK/cmd/SetEnv.sh\n" }
        expect "#" { send "exit\n" } expect eof
EOF
    wait
    expect <<EOF >/dev/null 2>&1
        set timeout -1
        spawn ssh ossadm@${standby_ip}
        expect {
            "password" {send -- "${standby_ip_pwd}\n";}
            "~]" {send "\n";}
            ">" {send "\n";}
            "yes/no" {send "yes\n";exp_continue}
        }
        expect {
            ">" { send "bash ${scripts_path}/service/extend/${step_name}.sh $root_pwd $os_pkg_tar $os_pkg_gz $os_pkg_patch\n";}
            "~]" { send "bash ${scripts_path}/service/extend/${step_name}.sh $root_pwd $os_pkg_tar $os_pkg_gz $os_pkg_patch\n";}
        }
        expect {
            "~]" {send "exit\n";}
            ">" {send "exit\n";}
        }
EOF
    wait
    elif [[  ${upgrade_step} == "after" ]]
    then
        root_pwd_bak=${root_pwd}
        if [[ ${step_name} == "reboot_os_after_os_online" ]]
        then
            # reboot_os_after_os_online的第一个参数接收的是upgrade 或者 rollback
            root_pwd=$7
        fi
    export TMOUT=100000
    expect <<EOF >/dev/null 2>&1
        set timeout -1
        spawn ssh -o ServerAliveInterval=60 ${ssh_user_for_after}@${standby_ip}
        expect {
            "password" {send -- "${ssh_pwd_for_after}\n";}
            "yes/no" {send "yes\n";exp_continue}
        }
        expect {
            ">" { send "su - root\n";}
            "~]" { send "su - root\n";}
        }
        expect "Password:" { send -- "${root_pwd_bak}\n" }
        expect "#" { send "su - ossadm\n" }
        expect {
            ">" { send "bash ${scripts_path}/service/extend/${step_name}.sh $root_pwd $os_pkg_tar $os_pkg_gz $os_pkg_patch\n";}
            "~]" { send "bash ${scripts_path}/service/extend/${step_name}.sh $root_pwd $os_pkg_tar $os_pkg_gz $os_pkg_patch\n";}
        }
        expect {
            "~]" {send "exit\n";}
            ">" {send "exit\n";}
        }
        expect "#" { send "exit\n" } expect eof
EOF
    wait
    elif [[  ${upgrade_step} == "rollback" ]]
    then
    expect <<EOF >/dev/null 2>&1
        set timeout -1
        spawn ssh ossadm@${standby_ip}
        expect {
            "password" {send -- "${standby_ip_pwd}\n";}
            "yes/no" {send "yes\n";exp_continue}
        }
        expect {
            ">" { send "bash ${scripts_path}/service/extend/${step_name}.sh $root_pwd $os_pkg_tar $os_pkg_gz $os_pkg_patch\n";}
            "~]" { send "bash ${scripts_path}/service/extend/${step_name}.sh $root_pwd $os_pkg_tar $os_pkg_gz $os_pkg_patch\n";}
        }
        expect {
            "~]" {send "exit\n";expect eof}
            ">" {send "exit\n";expect eof}
        }
EOF
    wait
    fi

}

main >> ${log_file} 2>&1