#!/bin/bash

os_pkg_tar=${1}
os_pkg_gz=${2}
os_pkg_patch=${3}
ip=${4}
temporary_dir=${5}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@"

function main()
{
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start to prepare /opt/os_patch_online"
    # 解压目录
    os_patch_online=/opt/os_patch_online
    if [[ -d /opt/os_patch_online ]]
    then
        rm -rf ${os_patch_online}
    fi
    mkdir -p ${os_patch_online}
    cp -rfa /opt/oss/${os_pkg_tar} ${os_patch_online}
    chown -R root:root ${os_patch_online}

    # 结果目录
    os_patch_online_result=${temporary_dir}/os_online_upgrade_result_${ip}.txt
    if [[ -f ${os_patch_online_result} ]]
    then
        su - ossadm -c "rm -rf ${os_patch_online_result}"
    fi

    # 重启的记录
    if [[ -f ${temporary_dir}/os_online_reboot_for_upgrade.flag ]]
    then
        su - ossadm -c "rm -rf ${temporary_dir}/os_online_reboot_for_upgrade.flag"
    fi

    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start to unzip os_patch.tar"
    cd ${os_patch_online}
    rm -rf os_patch
    tar -xf ${os_pkg_tar}
    tar -xf ${os_pkg_gz}
    tar -xf ${os_pkg_gz}
    mv ${os_pkg_patch} os_patch
    cd ${os_patch_online}/os_patch
    tar -xf os_sudobin_pkg.tar
    tar -xf os_sudobin.tar
    chown -R root:root ${os_patch_online}
    bash os_upgrade_online.sh
    result=$?
    if [[ ${result} -eq 0 ]];then
        echo "success install, result_code: ${result}" > ${os_patch_online_result}
    elif [[ ${result} -eq 9 ]];then
        echo "success skip, result_code: ${result}" > ${os_patch_online_result}
    else
        echo "failed install, result_code: ${result}" > ${os_patch_online_result}
    fi
    chown ossadm: ${os_patch_online_result}

}

main
