#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${EXEC_HOME}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log

function main()
{
    des_dir=/opt/oss/easysuite/easysuite/var/temp/iMasterNCE-Fabric_zip_dir
    # 压缩后，不再重复压缩，避免只存在几个文件，导致压缩脚本不全
    if [[ -f ${des_dir}/scripts.zip ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "file has been compressed"
        exit 0
    fi
    mkdir -p ${des_dir}

    plugin_dir=/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric
    upgrade_online_dir=${plugin_dir}/upgrade_online
    service_dir=${plugin_dir}/upgrade_online/service

    # 压缩
    cd ${upgrade_online_dir}
    zip -rqo databasemigrate.zip databasemigrate
    result1=$?
    mv databasemigrate.zip ${des_dir}
    cd ${service_dir}
    zip -rqo extend.zip extend
    result2=$?
    zip -rqo scripts.zip scripts
    result3=$?
    if [[ ${result1} != "0" ]] || [[ ${result2} != "0" ]] || [[ ${result3} != "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "unzip file failed: result1: ${result1}, result2: ${result2}, result3: ${result3}"
        exit 1
    fi
    mv extend.zip ${des_dir}
    mv scripts.zip ${des_dir}
    # 需要保留的文件
    mv ${service_dir}/extend/prepare_rollback_scripts.py ${des_dir}
    mv ${service_dir}/extend/prepare_rollback_scripts.sh ${des_dir}
    mv ${service_dir}/extend/set_log.py ${des_dir}
    mv ${service_dir}/extend/compare_database.py ${des_dir}
    mv ${service_dir}/extend/zip_upgrade_scripts.sh ${des_dir}
    mv ${service_dir}/scripts/get_log_dir.sh ${des_dir}


    # 删除
    rm -rf ${plugin_dir}/V*
    rm -rf ${service_dir}/extend
    rm -rf ${service_dir}/scripts
    rm -rf ${upgrade_online_dir}/databasemigrate
    # temp目录下的也删掉
    rm -rf /opt/oss/easysuite/easysuite/var/temp/upgrade/databasemigrate/iMasterNCE-Fabric
    rm -rf /opt/oss/easysuite/easysuite/var/temp/upgrade/upgrade/iMasterNCE-Fabric

    # 保留回滚准备的脚本
    mkdir -p ${service_dir}/extend
    mv ${des_dir}/prepare_rollback_scripts.py ${service_dir}/extend/
    mv ${des_dir}/prepare_rollback_scripts.sh ${service_dir}/extend/
    mv ${des_dir}/set_log.py ${service_dir}/extend/
    mv ${des_dir}/compare_database.py ${service_dir}/extend/
    mv ${des_dir}/zip_upgrade_scripts.sh ${service_dir}/extend/
    mkdir -p ${service_dir}/scripts
    mv ${des_dir}/get_log_dir.sh ${service_dir}/scripts

}
main >> ${log_file} 2>&1
