#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
db_report="/opt/oss/post_upgrade_report/db_difference_report"
base_line_file=${CUR_PATH}/base_line
upgrade_file=${CUR_PATH}/upgrade

sh get_table_info.sh upgrade

if [ -d ${db_report} ]
then
    rm -rf ${db_report}
fi
mkdir -p ${db_report}
cp -rf ${base_line_file} ${db_report}
cp -rf ${upgrade_file} ${db_report}

# 调用easysuite的python
if [[ -d /opt/oss/easysuite/easysuite/3rdparty ]]
then
    if [[ -d /opt/oss/easysuite/easysuite/3rdparty/Python38 ]]
    then
        easysuite_path="/opt/oss/easysuite/easysuite/3rdparty/Python38/lib/python3.8/site-packages"
    else
        easysuite_path="/opt/oss/easysuite/easysuite/3rdparty/Python39/lib/python3.9/site-packages"
    fi
else
    if [[ -d /opt/oss/easysuite/easysuite/easysuite/3rdparty/Python38 ]]
    then
        easysuite_path="/opt/oss/easysuite/easysuite/easysuite/3rdparty/Python38/lib/python3.8/site-packages"
    else
        easysuite_path="/opt/oss/easysuite/easysuite/easysuite/3rdparty/Python39/lib/python3.9/site-packages"
    fi
fi

. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${easysuite_path}');import compare;compare.main('${base_line_file}', '${upgrade_file}', '${db_report}')"



