'''
create_json_file.py
'''

import os
import sys
import json


def main():
    '''
    main
    :return:
    '''
    base_dir = sys.argv[1]
    result_dict = {}
    for instance_name in os.listdir(base_dir):
        result_dict[instance_name] = {}
        instance_name_dir = os.path.join(base_dir, instance_name)
        for db_name in os.listdir(instance_name_dir):
            result_dict[instance_name][db_name] = {}
            db_name_dir = os.path.join(instance_name_dir, db_name)
            for table_name in os.listdir(db_name_dir):
                result_dict[instance_name][db_name][table_name] = {}
                table_name_path = os.path.join(db_name_dir, table_name)
                with open(table_name_path, "rb") as _f:
                    table_structure = json.load(_f)
                    for key, value in table_structure.items():
                        result_dict[instance_name][db_name][table_name][key] = value
    with open("%s.json" % os.path.split(base_dir)[1], "w") as json_f:
        json.dump(result_dict, json_f)


if __name__ == '__main__':
    main()

