#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
if [[ -d /opt/oss/NCECOMMONE ]]
then
    base_dir=/opt/oss/NCECOMMONE/apps
else
    base_dir=/opt/oss/NCE/apps
fi

for service_name in `ls ${base_dir}`
do
    echo ${base_dir}/${service_name}/pub/app_define.json
    upgrade_name=`python -c "import sys;import get_upgrade_command;print(get_upgrade_command.main('${base_dir}/${service_name}/pub/app_define.json'))"`
    if [[ ! -z ${upgrade_name} ]]
    then
        echo "$(date "+%Y-%m-%d %H:%M:%S") [sh ${base_dir}/${service_name}/${upgrade_name}]"
        cp ${base_dir}/${service_name}/envs/upgrade.properties ${base_dir}/${service_name}/envs/upgrade_export.properties
        sed -i 's/^/export &/g' ${base_dir}/${service_name}/envs/upgrade_export.properties
        cp ${base_dir}/${service_name}/envs/upgrade.properties ${base_dir}/${service_name}/envs/upgrade_unset.properties
        sed -i 's/=.*//g' ${base_dir}/${service_name}/envs/upgrade_unset.properties
        sed -i 's/^/unset &/g' ${base_dir}/${service_name}/envs/upgrade_unset.properties
        . ${base_dir}/${service_name}/envs/upgrade_export.properties
        sh ${base_dir}/${service_name}/${upgrade_name}
        . ${base_dir}/${service_name}/envs/upgrade_unset.properties
        rm -rf ${base_dir}/${service_name}/envs/upgrade_export.properties
        rm -rf ${base_dir}/${service_name}/envs/upgrade_unset.properties
    fi
    echo "$(date "+%Y-%m-%d %H:%M:%S") ====================================================================="
done


