#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
service_name=SecoManagerService
python_path=${1}

if [[ -d /opt/oss/NCECOMMONE/apps ]]
then
    base_dir=/opt/oss/NCECOMMONE/apps
else
    base_dir=/opt/oss/NCE/apps
fi

if [[ -d  ${base_dir}/${service_name} ]]
then
    echo ${base_dir}/${service_name}/pub/app_define.json
    upgrade_name=`${python_path}/bin/python -c "import sys;import get_upgrade_command;print(get_upgrade_command.main('${base_dir}/${service_name}/pub/app_define.json'))"`
    if [[ ! -z ${upgrade_name} ]]
    then
        echo "$(date "+%Y-%m-%d %H:%M:%S") [sh ${base_dir}/${service_name}/${upgrade_name}]"
        cp ${base_dir}/${service_name}/envs/upgrade.properties ${base_dir}/${service_name}/envs/upgrade_export.properties
        sed -i 's/^/export &/g' ${base_dir}/${service_name}/envs/upgrade_export.properties
        cp ${base_dir}/${service_name}/envs/upgrade.properties ${base_dir}/${service_name}/envs/upgrade_unset.properties
        sed -i 's/=.*//g' ${base_dir}/${service_name}/envs/upgrade_unset.properties
        sed -i 's/^/unset &/g' ${base_dir}/${service_name}/envs/upgrade_unset.properties
        . ${base_dir}/${service_name}/envs/upgrade_export.properties
        sh ${base_dir}/${service_name}/${upgrade_name}
        . ${base_dir}/${service_name}/envs/upgrade_unset.properties
        rm -rf ${base_dir}/${service_name}/envs/upgrade_export.properties
        rm -rf ${base_dir}/${service_name}/envs/upgrade_unset.properties
    fi
    echo "$(date "+%Y-%m-%d %H:%M:%S") ====================================================================="
else
    echo "$(date "+%Y-%m-%d %H:%M:%S") SecoManagerService is not installed,skip"
    exit 0
fi


