#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
instance_name=$1
db_name=$2

get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`
    if [ -z "$dbinfo" ]
    then
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
        db_type=`echo $dbinfo|awk '{print $9}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Slave|awk '{print $3}'`
        db_type=`echo $dbinfo|awk '{print $9}'`
    fi
}
main(){
    export_data_common="/opt/oss/export_data_common"
    export_data_common_log="/opt/oss/export_data_common_log"
    rm -rf $export_data_common
    mkdir -p $export_data_common
    chmod -R 777 $export_data_common
    rm -rf $export_data_common_log
    mkdir -p $export_data_common_log
    chmod -R 777 $export_data_common_log

    get_dbip_port $instance_name
    db_info=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${instance_name}', '${db_name}', 'zenith'))" 2>&1)
    result_array=(${db_info//,/ })
    adminPP=${result_array[2]}

    retry_times=5
    for((i=1;i<=${retry_times};i++))
    do
        sudo -s -u dbuser<<EOF
        mkdir -p ${export_data_common}/${instance_name}
        mkdir -p ${export_data_common_log}/${instance_name}
        source /home/dbuser/.bashrc
        /opt/zenith/app/bin/zsql ${db_name}/${adminPP}@${MACHINE_IP}:${port} -c "EXP USERS = ${db_name} FILE='${export_data_common}/${instance_name}/${db_name}.dmp' FILETYPE=BIN PARALLEL=8 consistent=Y;" | tee ${export_data_common_log}/${instance_name}/${db_name}.log 2>&1
        chmod -R 777 $export_data_common_log/*
EOF
        is_success=$(cat ${export_data_common_log}/${instance_name}/${db_name}.log | grep -i "Logical export succeeded")
        if [[ -z "$is_success" ]]
        then
            echo "${instance_name}.${db_name}: Logical export failed, retry_times: ${i}"
            if [[ ${i} -eq ${retry_times} ]]
            then
                exit 1
            fi
            sleep 10
        else
            echo "${instance_name}.${db_name}: Logical export succeeded."
            break
        fi
    done
    cd $export_data_common
    sudo -u dbuser chmod 777 -R *
}
main
