#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
script_name=`basename $0`
UPGRADE=${1}

print_log()
{
    local content=$*
    log_filename="$CUR_PATH/update_nw.log"
    echo $log_filename 
    CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
    echo "Log: $CURTIME $$ $script_name : $content" | tee -a $log_filename
}

#获取数据库信息（query database)
get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`

    if [ -z "$dbinfo" ]
    then
        print_log "$LINENO single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
        db_type=`echo $dbinfo|awk '{print $9}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Slave|awk '{print $3}'`
        db_type=`echo $dbinfo|awk '{print $9}'`
    fi

    
}

get_table_structure(){
    # get db info
    local db_name=${1}
    local instance_name=${2}
    local table_structrue=${3}
    local db_info=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${instance_name}', '${db_name}', 'zenith'))" 2>&1`
    local result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully." ${instance_name} ${db_name}
        local result_array=(${db_info//,/ })
        local adminPP=${result_array[2]}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
        exit 1
    fi

    . /opt/oss/manager/agent/bin/engr_profile.sh; python ${CUR_PATH}/get_table_structure.py ${db_name} ${adminPP} ${MACHINE_IP} ${port} ${instance_name} ${table_structrue} ${UPGRADE} ${instance_name} ${table_structrue}
}

main(){

    table_structrue="/opt/oss/get_table_structure/${UPGRADE}"
    if [ -d ${table_structrue} ]
    then
        rm -rf ${table_structrue}
    fi


    for instance_name_ip in `sudo -u dbuser ls /opt/zenith/data`
    do
        instance_name_array=(${instance_name_ip//-/ })
        instance_name=${instance_name_array[0]}
        echo ${instance_name}
        #运行函数：获取数据库ip,port, admin password
        get_dbip_port ${instance_name}
        # 获取db_names
        db_names=`. /opt/oss/manager/agent/bin/engr_profile.sh; python ${CUR_PATH}/get_db_names.py ${instance_name} ${MACHINE_IP} ${port} zenith`
        echo ${db_names}
        for db_name in ${db_names//,/ }
        do
            get_table_structure ${db_name} ${instance_name} ${table_structrue} &
        done
    done
    wait
    echo "get all table structure success"
    . /opt/oss/manager/agent/bin/engr_profile.sh; python ${CUR_PATH}/create_json_file.py ${table_structrue}
}

main


