#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=$(sh ${CUR_PATH}/../get_log_dir.sh)
log_file=${log_dir}/${self_name}.log
instance_name=$1
db_name=$2

#获取数据库信息（query database)
get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`
    if [ -z "$dbinfo" ]
    then
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
        db_type=`echo $dbinfo|awk '{print $9}'`
        master_instance_id=`echo $dbinfo|awk '{print $1}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Slave|awk '{print $3}'`
        db_type=`echo $dbinfo|awk '{print $9}'`
        master_instance_id=`echo $dbinfo|awk '{print $1}'`
    fi
}

main(){
    export_data="/opt/oss/export_data_common"
    import_data_common_log="/opt/oss/import_data_common_log"
    rm -rf ${import_data_common_log}
    mkdir -p ${import_data_common_log}
    chmod -R 777 ${import_data_common_log}
    get_dbip_port $instance_name
    db_info=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${instance_name}', '${db_name}', 'zenith'))" 2>&1)
    result_array=(${db_info//,/ })
    adminPP=${result_array[2]}
    retry_times=5
    for((i=1;i<=${retry_times};i++))
    do
        sudo -s -u dbuser<<EOF
        mkdir -p ${import_data_common_log}/${instance_name}
        source /home/dbuser/.bashrc
        /opt/zenith/app/bin/zsql ${db_name}/${adminPP}@${MACHINE_IP}:${port} -c "IMP USERS = ${db_name} FILE='${export_data}/${instance_name}/${db_name}.dmp' FILETYPE=BIN PARALLEL=8 DDL_PARALLEL=4;" | tee ${import_data_common_log}/${instance_name}/${db_name}.log 2>&1
        chmod -R 777 ${import_data_common_log}/*
EOF
        is_success=$(cat ${import_data_common_log}/${instance_name}/${db_name}.log | grep -i "Logical import succeeded")
        if [[ -z "$is_success" ]]
        then
            echo "${instance_name}.${db_name}: Logical import failed, retry_times: ${i}"
            if [[ ${i} -eq ${retry_times} ]]
            then
                exit 1
            fi
            sleep 10
        else
            echo "${instance_name}.${db_name}: Logical import succeeded."
            break
        fi
    done
}

main >> ${log_file} 2>&1

