#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
upgrade_type=${4}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main()
{
     modify_product_info="${EXEC_HOME}/../pyscripts/modify_product_info.py"
     timeStamp=`date +"%Y%m%d%H%M%S"`
     mkdir /opt/upgrade/change_product_info_${timeStamp}
     bash /opt/oss/manager/tools/resmgr/queryproduct.sh -pn ${tenant_name} -output /opt/upgrade/change_product_info_${timeStamp}
     PRODUCT_NCEDCN_FILE="/opt/upgrade/change_product_info_${timeStamp}/product_${tenant_name}.json"
     echo "${PRODUCT_NCEDCN_FILE}"
     is_change=$(. /opt/oss/manager/bin/engr_profile.sh;${PYTHONHOME}/bin/python ${modify_product_info} ${PRODUCT_NCEDCN_FILE} ${upgrade_type} ${log_dir})
     echo ${is_change}
     if [[ ${is_change} == "change" ]]
     then
         bash /opt/oss/manager/tools/resmgr/modifyproductinfo.sh -input ${PRODUCT_NCEDCN_FILE}
         result=$?
         if [[ "${result}" == "0" ]]
         then
             echo "Change product info successfully."
         else
             echo "Change product info failed."
             exit 1
        fi
    fi

}

main $@ >> ${log_file} 2>&1