#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
sql_type=${4}
sql_content=${5}
db_type=${6}
instance_name=${7}
db_name=${8}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function check_sql_type()
{
    if [[ ${sql_type} != "file" ]] && [[ ${sql_type} != "sql" ]]
    then
        echo $(date '+%Y-%m-%d %H:%M:%S') [ERROR] "sql_type is invaild, sql_type: ${sql_type}"
        return 1
    fi
    return 0
}

function check_sql_file()
{
    local sql_file_path=${1}
    if [[ ! -f ${sql_file_path} ]]
    then
        echo $(date '+%Y-%m-%d %H:%M:%S') [ERROR] "${sql_file_path} is not exists"
        return 1
    fi

    if [[ -z  $(cat ${EXEC_HOME}/../plugins/sql_file/sql.json | grep ${sql_content}) ]]
    then
        echo $(date '+%Y-%m-%d %H:%M:%S') [ERROR] "${sql_content} not in sql.json"
        return 1
    fi
    return 0
}


function main(){

    check_sql_type || exit 1
    # 执行sql
    cd ${EXEC_HOME}/../pyscripts/utils
    . /opt/oss/manager/bin/engr_profile.sh

    if [[ ${sql_type} == "file" ]]
    then
        absolution_sql_file=${EXEC_HOME}/../plugins/sql_file/${sql_content}
        check_sql_file ${absolution_sql_file} || exit 1
        return_code=$(${PYTHONHOME}/bin/python -c "import common_method;print(common_method.CommonMethod().exec_sql('${db_type}', '${instance_name}', '${db_name}', sql_file='''${absolution_sql_file}'''))")
    elif [[ ${sql_type} == "sql" ]]
    then
        return_code=$(${PYTHONHOME}/bin/python -c "import common_method;print(common_method.CommonMethod().exec_sql('${db_type}', '${instance_name}', '${db_name}', sql='''${sql_content}'''))")
    fi

    if [[ $? == "0" ]] && [[ "${return_code}" == "0" ]]
    then
        echo $(date '+%Y-%m-%d %H:%M:%S') [INFO] "exec sql successfully"
    else
        echo $(date '+%Y-%m-%d %H:%M:%S') [INFO] "exec sql failed"
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1