#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function main()
{
    ###调用迁移工具迁移(包含R20C00 - R20C10逃生链路迁移)
    echo "$(date "+%Y-%m-%d %H:%M:%S") migrate data begin"
    . /opt/oss/manager/bin/engr_profile.sh;${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/pre_migrate_data.py ${data_migrate_dir} ${upgrade_path}
    if [ $? -ne 0 ];then
        echo "$(date "+%Y-%m-%d %H:%M:%S") [Migrate failed,Please see ${log_dir}/logs]"
        exit 1
    fi
    echo "$(date "+%Y-%m-%d %H:%M:%S") migrate data success"
    # 拷贝日志
    [[ -d ${log_dir}/logs ]] && rm -rf ${log_dir}/logs
    [[ -d ${log_dir}/config ]] && rm -rf ${log_dir}/config
    cp -rf ${data_migrate_dir}/logs ${log_dir}
    cp -rf ${data_migrate_dir}/config ${log_dir}
    echo "$(date "+%Y-%m-%d %H:%M:%S") copy file success"
}

main $@ >> ${log_file} 2>&1