#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "data_migrate_dir is ${data_migrate_dir}" | tee -a ${log_file}

function main(){
    #数据源迁移
    cd ${EXEC_HOME}/../plugins/datastore_migrate
    bash upgrade_datastore.sh ${tenant_name}
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo "upgrade datastore successfully."
    else
        echo "upgrade datastore failed."
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1