#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "data_migrate_dir is ${data_migrate_dir}" | tee -a ${log_file}

function main(){
    # 迁移前删除data_change
    retry_times=8
    cd ${EXEC_HOME}/../plugins/data_change_sql
    for((i=1;i<=${retry_times};i++))
    do
        . /opt/oss/manager/bin/engr_profile.sh; bash migrate_common.sh
        result=$?
        if [[ "${result}" == "0" ]]
        then
            echo "delete data change successfully."
            break
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "delete data change failed, retry_times: ${i}"
            if [[ ${i} -eq ${retry_times} ]]
            then
                exit 1
            fi
            sleep 5
        fi
    done
}

main $@ >> ${log_file} 2>&1