#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function main()
{
    # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS=$(python ${EXEC_HOME}/../pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}" >> ${log_file}
            echo "$IPS"
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed" >> ${log_file}
            exit 1
    fi

    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        retry_times=5
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start copy file"
        for((i=1;i<=${retry_times};i++))
        do
            ssh -o StrictHostKeyChecking=no ossadm@${ip} rm -rf /opt/oss/plugin-security.policy
            result1=$?
            scp -r ${EXEC_HOME}/plugin-security.policy ossadm@[$ip]:/opt/oss
            result2=$?
            if [[ ${result1} == "0" ]] && [[ ${result2} == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success copy file"
                break
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "failed copy file, retry_times: ${i}"
                if [[ ${i} -eq ${retry_times} ]]
                then
                    exit 1
                fi
                sleep 10
            fi
        done
    done

    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        retry_times=5
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start overwrite file"
        for((i=1;i<=${retry_times};i++))
        do
            ssh -o StrictHostKeyChecking=no ossadm@${ip} << EOF
                if [[ -f /opt/oss/rtsp/ElasticSearch-23.22.2023/plugins/es-ssl/plugin-security.policy ]]
                then
                    cp -rf /opt/oss/plugin-security.policy /opt/oss/rtsp/ElasticSearch-23.22.2023/plugins/es-ssl/
                    chmod 440 /opt/oss/rtsp/ElasticSearch-23.22.2023/plugins/es-ssl/plugin-security.policy
                    rm -rf /opt/oss/plugin-security.policy
                fi
EOF
            result=$?
            if [[ ${result} == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success overwrite file"
                break
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "failed overwrite file, retry_times: ${i}"
                if [[ ${i} -eq ${retry_times} ]]
                then
                    exit 1
                fi
                sleep 10
            fi
        done
    done
}

main $@ >> ${log_file} 2>&1