#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function main()
{
    retry_times=120
    for((i=1;i<=${retry_times};i++))
    do
        result=$(/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNService")
        result_code=$?
        echo "result: ${result}"
        # 如果上个命令不为0，且命令返回结果为空，且命令返回结果包含 No matched processes，都视为失败
        if [[ ${result_code} != "0" ]] || [[ "${result}X" = "X" ]] || [[ ${result} == *"No matched processes"* ]]
        then
            echo "result_code: ${result_code}"
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "can not find DCNService status, wait, execute times: ${i}"
            if [[ ${i} -eq ${retry_times} ]]
            then
                exit 1
            fi
            sleep 10
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "find DCNService status success"
            break
        fi
    done
}

main $@ >> ${log_file} 2>&1