#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
out_put_file=${4}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}

function main()
{
    # 根据节点获取节点标签文件
    . /opt/oss/manager/bin/engr_profile.sh
    node_num=$(${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/get_node_number.py ${tenant_name})
    case ${node_num} in
    1)
        node_tag_template="nodetag_1.json"
        ;;
    3)
        node_tag_template="nodetag_3.json"
        ;;
    5)
        node_tag_template="nodetag_5.json"
        ;;
    7)
        node_tag_template="nodetag_7.json"
        ;;
    9)
        node_tag_template="nodetag_3+2.json"
        ;;
    *)
        node_tag_template=""
    esac
    # mdc的节点标签判断
    mdc=`cat ${EXEC_HOME}/product_${tenant_name}.json |grep -w MDC_DEPLOYMENT_TYPE`
    if [[ "${mdc}X" != "X" ]]; then
       echo "$(date "+%Y-%m-%d %H:%M:%S") mdc scene"
       if [[ ${node_num} == "1" ]]
       then
           node_tag_template="nodetag_1.json"
       else
           node_tag_template="nodetag_DeployMDC_3.json"
       fi
    fi
    echo "$(date "+%Y-%m-%d %H:%M:%S") node_tag_template: ${node_tag_template}"

    if [[ "${node_tag_template}X" == "X" ]]; then
        echo "$(date "+%Y-%m-%d %H:%M:%S") [ERROR] Current software do not support upgrade to this version."
        exit 1
    fi

    # 创建节点标签
    ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/create_node_tags.py ${EXEC_HOME}/../nodetagTemplates/${node_tag_template} ${out_put_file}/node_plan_${tenant_name}.json ${tenant_name}
    result=$?
    if [[ "${result}" == "0" ]]
        then
            echo "$(date "+%Y-%m-%d %H:%M:%S") [INFO] create_node_tags successfully"
        else
            echo "$(date "+%Y-%m-%d %H:%M:%S") [ERROR] create_node_tags failed"
            exit 1
    fi
}


main $@ >> ${log_file} 2>&1