#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
out_put_file=${4}
in_put_file=${5}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}

function main()
{
    param_plan_json="${EXEC_HOME}/../${upgrade_path}/param_plan_iMasterNCE-Fabric.json"
    if [[ ! -f ${param_plan_json} ]]
    then
        echo $(date '+%Y-%m-%d %H:%M:%S') [INFO] "${param_plan_json} dose not exist, no need change params, skip"
        exit 0
    fi
    now_version=${upgrade_path%%-*}

    product_info_file=${EXEC_HOME}/product_${tenant_name}.json
    is_adnbasic_feature=$(cat ${product_info_file} |grep -w "adnbasic_feature")
    is_design_feature=$(cat ${product_info_file} |grep -w "design_feature")
    is_fault_feature=$(cat ${product_info_file} |grep -w "fault_feature")
    is_runbook_feature=$(cat ${product_info_file} |grep -w "runbook_feature")
    is_dtagent_feature=$(cat ${product_info_file} |grep -w "dtagent_feature")
    mdc=$(cat ${product_info_file} |grep -w MDC_DEPLOYMENT_TYPE)

    . /opt/oss/manager/bin/engr_profile.sh
    #获取升级共同需要的参数值
    north_float_ip=$(${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/get_north_floatip.py)
    if [[ "$north_float_ip" == *":"* ]]
    then
        manage_address="[$north_float_ip]:31945"
    else
        manage_address="$north_float_ip:31945"
    fi
    uniopornic=$(${PYTHONHOME}/bin/python -c "import json;f=open('${in_put_file}/product_${tenant_name}.json','r');obj=json.load(f);f.close();print (obj['productext']['SouthInterface'])")
    echo $uniopornic

    # modify param for IPUsage
    result_north=`cat /opt/oss/manager/etc/sysconf/nodelists.json |grep "NORTH_FLOATIP"`
    if [ "${result_north}X" != "X" ]; then
        result=`cat /opt/oss/manager/etc/sysconf/nodelists.json |grep "NORTH_FLOATIP2"`
        if [ "${result}X" != "X" ]; then
            ipusage="WEBSOCKET[NORTH_FLOATIP,NORTH_FLOATIP2]"
        else
            ipusage="WEBSOCKET[NORTH_FLOATIP]"
        fi
    else
        ipusage="WEBSOCKET[Northbound]"
    fi

    sed -i "s/IPUSAGE_STR/${ipusage}/g" $param_plan_json
    sed -i "s/uniIpOrNic_value/${uniopornic}/g" $param_plan_json

    # 增加dtagent_feature相关的参数(安装了 设计态、mdc、runbook的，要置is_DTAgentService_Installed_str为true)
    if [ "${is_design_feature}X" != "X" ] || [ "${mdc}X" != "X" ] || [ "${is_runbook_feature}X" != "X" ] || [ "${is_dtagent_feature}X" != "X" ];then
        sed -i "s/is_DTAgentService_Installed_str/true/g" $param_plan_json
        sed -i "s/DATA_CHANGE_ENABLE_str/true/g" $param_plan_json
    else
        sed -i "s/is_DTAgentService_Installed_str/false/g" $param_plan_json
        sed -i "s/DATA_CHANGE_ENABLE_str/false/g" $param_plan_json
    fi

    # mdc场景的参数
    if [ "${mdc}X" != "X" ]; then
        sed -i "s/homepageURL_VALUE/\/mdcwebsite\/mdc\/index.html/g" $param_plan_json
        sed -i "s/MDC_DEPLOYMENT_ENABLE_str/true/g" $param_plan_json
    else
        sed -i "s/homepageURL_VALUE/\/dcnwebsite\/dcn\/index.html/g" $param_plan_json
        sed -i "s/MDC_DEPLOYMENT_ENABLE_str/false/g" $param_plan_json
    fi

    #获取sc参数
    sc_ip1=$(. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../pyscripts');import get_ip_by_num;print(get_ip_by_num.get_ip('1'))")
    sc_ip2=$(. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../pyscripts');import get_ip_by_num;print(get_ip_by_num.get_ip('2'))")
    cse_ip1="${sc_ip1},${sc_ip2}"
    #ipv6处理
    if [[ $sc_ip1 =~ ":" ]]
    then
        sc_ip1="[$sc_ip1]"
        sc_ip2="[$sc_ip2]"
    fi
    cse_ip2="https://${sc_ip1}:30100,https://${sc_ip2}:30100"

    ##V100R020C00
    result=$(echo $now_version | grep "V100R020C00")
    if [ "${result}X" != "X" ]; then
        sed -i "s/MANAGE_ADDRESS_STR/${manage_address}/g" $param_plan_json
        sed -i "s#SERVICECENTER_STR#${cse_ip2}#g" $param_plan_json
        sed -i "s/CSE_CENTER_ADDR_STR/${cse_ip1}/g" $param_plan_json
        sed -i "s#CSE_SERVICE_CENTER_ADDRESS_STR#${cse_ip2}#g" $param_plan_json
    fi
    
    ##V300R019C00
    result=$(echo $now_version | grep "V300R019C00")
    if [ "${result}X" != "X" ]; then
        sed -i "s/MANAGE_ADDRESS_STR/${manage_address}/g" $param_plan_json
        str=$(. /opt/oss/manager/bin/engr_profile.sh;$PYTHONHOME/bin/python ${EXEC_HOME}/../pyscripts/updatenodes_NCE.py)
        str1=","
        str2=$(echo $str | grep "${str1}")
        str3=$(echo ${str//:9094})
        str4=$(echo ${str//9094/26310})
        sed -i "s#SERVICECENTER_STR#${cse_ip2}#g" $param_plan_json
        sed -i "s/CSE_CENTER_ADDR_STR/${cse_ip1}/g" $param_plan_json
        sed -i "s#CSE_SERVICE_CENTER_ADDRESS_STR#${cse_ip2}#g" $param_plan_json
        sed -i "s/KAFKA_LIST_VALUE/${str}/g" $param_plan_json
        sed -i "s/REPO_SERVER_ADDRESS_VALUE/${str3}/g" $param_plan_json
        sed -i "s/MGR_ZK_HOST_IP_VALUE/${str4}/g" $param_plan_json
        if [[ "$str2" != "" ]]
        then
            sed -i "s/INSTALL_CLUSTER_MODE_VALUE/2/g" $param_plan_json
            sed -i "s/FILE_DISTRIBUTE_SYSTYPE_VALUE/2/g" $param_plan_json
        else
            sed -i "s/INSTALL_CLUSTER_MODE_VALUE/1/g" $param_plan_json
            sed -i "s/FILE_DISTRIBUTE_SYSTYPE_VALUE/0/g" $param_plan_json
        fi
    fi

    ##V300R019C10
    result=$(echo $now_version | grep "V300R019C10")
    result2=$(echo $now_version | grep "V100R019C10")
    if [[ "${result}X" != "X" ]] || [[ "${result2}X" != "X" ]]; then
        sed -i "s/MANAGE_ADDRESS_STR/${manage_address}/g" $param_plan_json
        str=$(. /opt/oss/manager/bin/engr_profile.sh;$PYTHONHOME/bin/python ${EXEC_HOME}/../pyscripts/updatenodes_NCE.py)
        str1=","
        str2=$(echo $str | grep "${str1}")
        str3=$(echo ${str//:9094})
        str4=$(echo ${str//9094/26310})
        sed -i "s#SERVICECENTER_STR#${cse_ip2}#g" $param_plan_json
        sed -i "s/CSE_CENTER_ADDR_STR/${cse_ip1}/g" $param_plan_json
        sed -i "s#CSE_SERVICE_CENTER_ADDRESS_STR#${cse_ip2}#g" $param_plan_json
        sed -i "s/MGR_ZK_HOST_IP_VALUE/${str4}/g" $param_plan_json
    fi

    ##V100R020C10
    result=$(echo $now_version | grep "V100R020C10")
    if [ "${result}X" != "X" ]; then
        #定义特性
        sed -i "s/MANAGE_ADDRESS_STR/${manage_address}/g" $param_plan_json
        if [ "${mdc}X" != "X" ]; then
            sed -i "s/homepageURL_VALUE/\/mdcwebsite\/mdc\/index.html/g" $param_plan_json
        else
            sed -i "s/homepageURL_VALUE/\/dcnwebsite\/dcn\/index.html/g" $param_plan_json
        fi
    fi

    # R22C00新增参数(除了B版本升级都需要适配)
    result=$(echo $now_version | grep "V100R022C00")
    if [ "${result}X" == "X" ]; then
        param_dict='{"NCE_mgmtSize": "default"}'
        cd ${EXEC_HOME}/../pyscripts
        ${PYTHONHOME}/bin/python -c "import write_json_to_file;write_json_to_file.main('${param_plan_json}', '${param_dict}')"
    fi

    cp $param_plan_json $out_put_file 2>/dev/null
}


main $@ >> ${log_file} 2>&1