#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main()
{
    instname=$(/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep ODRSZenith |grep Master|awk '{print $1}')
    instance_ip=$(/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep ODRSZenith |grep Master|awk '{print $6}')
    # grep -w 精确匹配
    has_db_name=$(/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-database -instid ${instname} | grep -w dsoedesignerdb)
    if [[ -n ${has_db_name} ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "delete dsoedesignerdb"
        ssh -o StrictHostKeyChecking=no ossadm@${instance_ip} << EOF
            /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd remove-database -instid ${instname} -dbnames dsoedesignerdb
            exit
EOF
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "dsoedesignerdb dose not exists"
    fi
}
main $@ >> ${log_file} 2>&1