#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main()
{
    if [[ -f ${EXEC_HOME}/old_dbinstance.txt ]]
    then
        rm ${EXEC_HOME}/old_dbinstance.txt
    fi
    /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant ${tenant_name} | grep -e dcnnecommondb -e ncelocaldb -e ncecommondb -e ncesecmdb | grep Master | awk '{print $1 "\t" $6}' >> ${EXEC_HOME}/old_dbinstance.txt

    cat ${EXEC_HOME}/old_dbinstance.txt|while read line
    do
        instance_id=`echo $line|awk '{print $1}'`
        master_ip=`echo $line|awk '{print $2}'`
        echo "instance_id: ${instance_id}, master_ip: ${master_ip}"
        ssh -o StrictHostKeyChecking=no ossadm@$master_ip << EOF
        /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd delete-db-instance -instid $instance_id
        exit
EOF
    done
}
main $@ >> ${log_file} 2>&1