#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}

function main()
{
    #BGP场景删除第二个BGP节点浮动ip
    if [[ -d /opt/oss/${tenant_name}/apps/BgpService ]]
    then
        . /opt/oss/manager/agent/bin/engr_profile.sh
        ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/remove_float_ip.py "BGP"
        result=$?
        if [[ "${result}" == "0" ]]
        then
            echo "$(date '+%Y-%m-%d %H:%M:%S') [INFO] Check bgp float ip successfully"
        else
            echo "$(date '+%Y-%m-%d %H:%M:%S') [ERROR] Check bgp float ip failed"
            exit 1
        fi

        #等待刷新缓存
        sleep 60
    fi
}


main $@ >> ${log_file} 2>&1