#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
if [[ $(echo "$EXEC_HOME"  | grep -E "\s+") ]]
then
    echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "The path contains spaces: ${EXEC_HOME}"
    exit 1
fi
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
log_dir=`sh ${EXEC_HOME}/../get_log_dir.sh`
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main()
{
    # 为了解决安全问题，安装DynamicMapService需要的python三方包，MDC场景下安装
    # 无论是否安装DynamicMapService，都安装三方包，以免通过增加特性的方式不可用
    product_info_file=${EXEC_HOME}/product_${tenant_name}.json
    mdc=$(cat ${product_info_file} |grep -w MDC_DEPLOYMENT_TYPE)
    # 安装了MDC
    if [[ "${mdc}X" == "X" ]]
    then
        echo "$(date '+%Y-%m-%d %H:%M:%S') not mdc scene, skip install"
        exit 0
    else
        echo "$(date '+%Y-%m-%d %H:%M:%S') mdc scene, need install python 3rd package for DynamicMapService"

        if [[ -d ${log_dir}/DynamicMapService ]]
        then
            rm -rf ${log_dir}/DynamicMapService
        fi

        . /opt/oss/manager/bin/engr_profile.sh
        IPS=$(python ${EXEC_HOME}/../pyscripts/updatenodes_NCE.py)
        result=$?
        if [[ ${result} == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}"
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed"
                exit 1
        fi

        # 获取Python真实路径，并修改pip
        rtsp_path=$(dirname $(dirname ${PYTHONHOME}))
        python_path=$(ls -l ${rtsp_path}/rtsp | grep python | awk -F "->" '{print $2}')
        if [[ -z ${python_path} ]]
        then
            echo "$(date '+%Y-%m-%d %H:%M:%S') python_path is empty"
            exit 1
        fi
        new_bin="#!"${python_path}"/bin/python"

        # 获取工具包路径并解压
        cd ${EXEC_HOME}/../pyscripts/utils
        dir_name=/opt/pub/software/repository/Rtsp/3rdpart/DynamicMapServiceTool
        tool_dir=$(${PYTHONHOME}/bin/python -c "import common_method;print(common_method.get_biggest_version(dir_path='${dir_name}', contain='DynamicMapServiceTool', end='zip'))")
        result=$?
        if [[ -z ${tool_dir} ]] || [[ ${result} != "0" ]]
        then
            echo "$(date '+%Y-%m-%d %H:%M:%S') get tool_dir failed"
            exit 1
        fi
        unzip -o ${tool_dir} -d ${log_dir}/DynamicMapServiceTool
        if [[ $? != "0" ]]
        then
            echo "$(date '+%Y-%m-%d %H:%M:%S') unzip tool_dir failed"
            exit 1
        fi

        IPS_array=(${IPS//,/ })
        for ip_port in ${IPS_array[@]}
        do
            ip_port_array=(${ip_port//:9094/ })
            ip=${ip_port_array[0]}
            retry_times=5
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start copy file"
            for((i=1;i<=${retry_times};i++))
            do
                scp -r ${log_dir}/DynamicMapServiceTool ossadm@[$ip]:${INSTALL_ROOT}
                result=$?
                if [[ ${result} == "0" ]]
                then
                    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success copy file"
                    break
                else
                    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "failed copy file, retry_times: ${i}"
                    if [[ ${i} -eq ${retry_times} ]]
                    then
                        exit 1
                    fi
                    sleep 10
                fi
            done
        done

        for ip_port in ${IPS_array[@]}
        do
            ip_port_array=(${ip_port//:9094/ })
            ip=${ip_port_array[0]}
            ssh ossadm@"$ip" << remotessh
            # 开始安装
            # \$符号前面有反斜杠，变量不会提前计算。否则EOF中的变量都会提前计算出来
            echo "\$(date '+%Y-%m-%d %H:%M:%S') install python 3rd package in ${ip}"
            sed -i "1c $new_bin" ${python_path}/bin/pip3
            ${python_path}/bin/pip3 install --no-index --find-links=${INSTALL_ROOT}/DynamicMapServiceTool/python_lib/ -r ${INSTALL_ROOT}/DynamicMapServiceTool/python_lib/requirements.txt && rm -rf ${INSTALL_ROOT}/DynamicMapServiceTool
            exit
remotessh
        done
    fi
}

main >> ${log_file} 2>&1