#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function main()
{
    # 查询版本信息
    . /opt/oss/manager/bin/engr_profile.sh
    /opt/oss/manager/tools/resmgr/queryproduct.sh -pn ${tenant_name} -output ${EXEC_HOME}
    if [[ $? -ne 0 ]];then
        echo "$(date "+%Y-%m-%d %H:%M:%S") query product failed"
        exit 1
    else
        echo "$(date "+%Y-%m-%d %H:%M:%S") query product success"
    fi
}

main $@ >> ${log_file} 2>&1