#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
if [[ $(echo "$EXEC_HOME"  | grep -E "\s+") ]]
then
    echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "The path contains spaces: ${EXEC_HOME}" >> ${log_file}
    exit 1
fi
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
    # 微服务路径
    node_list_path="/opt/oss/manager/apps/MCHIROIRService/etc/sysconf/"
    file_name="nodelist.json"
    file_name2="nodelist2.json"

    . /opt/oss/manager/agent/bin/engr_profile.sh;
    cd ${EXEC_HOME}/../pyscripts
    node3_maintenance_ip=`${PYTHONHOME}/bin/python -c "import get_ip_by_num;print(get_ip_by_num.get_ip('2'))"`
    if [[ $? == "0" ]]
    then
        if [[ -z ${node3_maintenance_ip} ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the node3_maintenance_ip is empty, singe env, skip"
            exit 0
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get node3_maintenance_ip successfully: ${node3_maintenance_ip}"
        fi
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get node3_maintenance_ip failed"
        exit 1
    fi

    ssh -o StrictHostKeyChecking=no ossadm@${node3_maintenance_ip} ls ${node_list_path}
    if [[ $? != "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${node_list_path} does not exists, skip"
        exit 0
    fi

    north_float_ip=`${PYTHONHOME}/bin/python -c "import get_ip_by_num;print(get_ip_by_num.get_ip('0', 'NORTH_FLOATIP'))"`
    if [[ $? == "0" ]]
    then
        if [[ -z ${node3_maintenance_ip} ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "the north_float_ip is empty"
            exit 1
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get north_float_ip successfully: ${north_float_ip}"
        fi
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get north_float_ip failed"
        exit 1
    fi


    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start backup ${file_name} in ${node3_maintenance_ip}"
    ssh -o StrictHostKeyChecking=no ossadm@${node3_maintenance_ip} cp -rf ${node_list_path}/${file_name} ${node_list_path}/${file_name}.bak || exit 1

    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start copy ${file_name} from ${node3_maintenance_ip} to local"
    [[ -f ${temporary_dir}/${file_name} ]] && rm -rf ${temporary_dir}/${file_name}
    rsync ossadm@[${node3_maintenance_ip}]:${node_list_path}/${file_name} ${temporary_dir} || exit 1

    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start modify ${file_name}"
    [[ -f ${temporary_dir}/${file_name2} ]] && rm -rf ${temporary_dir}/${file_name2}
    cd ${EXEC_HOME}/../pyscripts
    ${PYTHONHOME}/bin/python -c "import modify_MCHIROIRService_nodelist;modify_MCHIROIRService_nodelist.modify_file('${temporary_dir}/${file_name}', '${temporary_dir}/${file_name2}', '${north_float_ip}')" || exit 1

    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start copy ${file_name} from local to ${node3_maintenance_ip}"
    rsync ${temporary_dir}/${file_name2} ossadm@[${node3_maintenance_ip}]:${node_list_path}/${file_name} || exit 1

}

main >> ${log_file} 2>&1
