#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    #修改BGP网口用途
    . /opt/oss/manager/agent/bin/engr_profile.sh
    bash /opt/oss/manager/tools/resmgr/queryproduct.sh -pn $tenant_name -output ${EXEC_HOME}
    $PYTHONHOME/bin/python ${EXEC_HOME}/../pyscripts/modify_bgp_nic_usage.py ${EXEC_HOME}/networkinfo_$tenant_name.json "rollback"
    result=$?
    if [[ "${result}" == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "modify_bgp_nic_usage successfully"
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "modify_bgp_nic_usage failed"
            exit 1
    fi
}

main $@ >> ${log_file} 2>&1