#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    repo_bak_dir=/opt/oss/upgrade_dir_for_ossuser/repo_bak
    HOFSOsdFileAgent=$(/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep -w "hofsosdfileagent-2-0" | awk '{print $6}')
    if [ "$HOFSOsdFileAgent" == "" ]
    then
        echo "restore repo package on the first node" >> ${log_file}
        sudo -u ossuser cp -rp ${repo_bak_dir}/* /opt/backup/hfs/repo/repo
        sudo -u ossuser /opt/oss/*/apps/HOFSOsdFileAgent/bin/hfscmd commit repo
    else
        echo "restore repo package on the third node" >> ${log_file}
        ssh ossadm@"$HOFSOsdFileAgent" << remotessh
            sudo -u ossuser cp -rp ${repo_bak_dir}/* /opt/backup/hfs/repo/repo
            sudo -u ossuser /opt/oss/*/apps/HOFSOsdFileAgent/bin/hfscmd commit repo
remotessh
    fi
}

main $@ >> ${log_file} 2>&1