#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
IPS=${4}

echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    # 恢复GlobalSearchService-elasticsearch备份的data目录数据
    back_data_dir="/opt/oss/upgrade_dir_for_ossuser/elasticsearch_bak/data"
    es_data_dir="/opt/oss/share/*/GlobalSearchService/elasticsearch/"
    /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "GlobalSearchService" | grep "elasticsearch" | awk '{print $6}' | while read line
    do
        echo "backup elasticsearch data in $line"
        ssh ossadm@"$line" << remotessh
            if [[ -d ${back_data_dir} ]]
            then
                echo "rollback elasticsearch data in $line"
                sudo -u ossuser rm -rf ${es_data_dir}/data
                sudo -u ossuser cp -rf ${back_data_dir} ${es_data_dir}
                /opt/oss/manager/agent/bin/ipmc_adm -cmd restartapp -app "GlobalSearchService"
            fi
            exit
remotessh
    done
}

main $@ >> ${log_file} 2>&1