#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    . /opt/oss/manager/agent/bin/engr_profile.sh
    local start_result=`${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/start_product.py $tenant_name "start"`
    if [ "${start_result}" == "success" ];then
        echo "[`date`] start product..."
        for (( i = 0; i < 900; i++ ))
        do
            local query_result=`${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/start_product.py $tenant_name "query"`
            if [ "${query_result}" == "success" ];then
                echo "[`date`] product start successful."
                return 0
            elif [ "${query_result}" == "starting" ];then
                mod=$(($i % 10))
                if [ $mod -eq 0 ]
                then
                    echo "[`date`] product is starting,please wait..."
                fi
                sleep 2
            fi
        done
    else
        echo "[`date`] start product failed."
        exit 1
    fi
    echo "[`date`] product start timeout."
    exit 1
}

main $@ >> ${log_file} 2>&1