#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    # 生成数据库差异报告（后台执行）
    cd ${EXEC_HOME}/../compare_database/
    bash export_db_upgrade.sh >> ${log_dir}/post_upgrade_report.log 2>&1 &
}

main $@ >> ${log_file} 2>&1