#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    # 自动查询版本号
    . /opt/oss/manager/bin/engr_profile.sh
    cd ${EXEC_HOME}/../pyscripts/utils
    is_same=$(${PYTHONHOME}/bin/python -c "import common_method;print(common_method.CommonMethod().compare_version())")
    result=$?
    is_same_version=`echo ${is_same} | grep "true" | wc -l`
    if [[ "${result}" == "0" ]] && [[ "${is_same_version}" -gt 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "compare version successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "compare version failed."
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1