#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

north_vis_ipv6=''

# 判断节点是否需要执行
function check_need()
{
    localip=$(. /opt/oss/manager/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "from util import common;print(common.getLocalIP())")
    setip=$(cat /opt/oss/manager/var/agent/managerip.conf | grep "^managerip" | awk -F= '{print $2}' | sed 's/,/\n/g' | sort -u | sed -n 1p)
    if [ "${localip}" == "${setip}" ]
    then
        return 0
    else
        return 1
    fi
}

function config_northipv6_sshd()
{
    sshd_tool="/opt/oss/manager/agent/bin/sshd_ipsadm.sh"
    if [[ -f "${sshd_tool}" ]]
    then
        # 启动加固，开放ipv6场景北向浮动ip的限制；解决管理面监控节点异常的问题
        bash /opt/oss/manager/agent/bin/sshd_ipsadm.sh -cmd set  -extips ${north_vis_ipv6} >/dev/null 2>&1
        if [ $? -ne 0 ]
        then
            logger -p local0.err "sek_root.sh;fail to bash /opt/oss/manager/agent/bin/sshd_ipsadm.sh -cmd set north_vis_ipv6"
            return 1
        else
            logger -p local0.info "sek_root.sh;success to bash /opt/oss/manager/agent/bin/sshd_ipsadm.sh -cmd set north_vis_ipv6"
            return 0
        fi
    else
        logger -p local0.err "sek_root.sh;fail to get /opt/oss/manager/agent/bin/sshd_ipsadm.sh"
        return 1
    fi
}


function main()
{
    cd ${EXEC_HOME}/../pyscripts
    # 开放ipv6场景北向浮动ip的限制
    north_vis_ipv6=$(. /opt/oss/manager/bin/engr_profile.sh;${PYTHONHOME}/bin/python get_north_floatip.py)
    if [[ ${north_vis_ipv6} =~ ':' ]]
    then
        check_need
        if [[ $? -eq 0 && "${north_vis_ipv6}" != "" ]]
        then
            echo 'north float ip IPV6'
            config_northipv6_sshd
        fi
    fi
    cd ${EXEC_HOME}

}

main $@ >> ${log_file} 2>&1