#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    echo "`date` start exec L23 sql"
    retry_times=8
    cd ${EXEC_HOME}/../plugins/dcnservice_migrate
    for((i=1;i<=${retry_times};i++))
    do
        bash migrate_common.sh
        if [[ $? -ne 0 ]];then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "exec L23 sql failed, retry_times: ${i}"
            if [[ ${i} -eq ${retry_times} ]]
            then
                exit 1
            fi
            sleep 5
        else
            echo "exec L23 sql success"
            break
        fi
    done
}

main $@ >> ${log_file} 2>&1