#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
upgrade_path=${1}
# get_version
. /opt/oss/manager/bin/engr_profile.sh
re_compile='R(\d+)C(\d+)'
src_r_version=$(${PYTHONHOME}/bin/python -c "import re;print(int(re.search('${re_compile}', '${upgrade_path}'.split('-')[0]).group(1)))")
src_c_version=$(${PYTHONHOME}/bin/python -c "import re;print(re.search('${re_compile}', '${upgrade_path}'.split('-')[0]).group(2))")
des_r_version=$(${PYTHONHOME}/bin/python -c "import re;print(int(re.search('${re_compile}', '${upgrade_path}'.split('-')[1]).group(1)))")
des_c_version=$(${PYTHONHOME}/bin/python -c "import re;print(re.search('${re_compile}', '${upgrade_path}'.split('-')[1]).group(2))")
if [[ -z ${src_r_version} ]] || [[ -z ${src_c_version} ]] || [[ -z ${des_r_version} ]] || [[ -z ${des_c_version} ]]
then
    echo "get src_version or des_version failed"
    echo "src_r_version: {src_r_version}"
    echo "src_c_version: {src_c_version}"
    echo "des_r_version: {des_r_version}"
    echo "des_r_version: {des_r_version}"
    exit 1
fi
src_version=R${src_r_version}C${src_c_version}
des_version=R${des_r_version}C${des_c_version}
echo "${src_version},${des_version}"