#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


start_or_stop_app(){
    /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "$1" | grep "$2" | awk '{print $6}' | while read line
    do
        echo "stop $1 in $line"
        ssh ossadm@"$line" << remotessh
            /opt/oss/manager/agent/bin/ipmc_adm -cmd $3 -app "$1"
            exit
remotessh
    done
}

cloudsop_upgradetool_migrate(){
    export MIGRATE_ROOT=/opt/oss/tmp_upgrade_tool
    rm -rf ${MIGRATE_ROOT}
    unzip -q ${EXEC_HOME}/../ImapUpgradeService*upgradetool.zip -d ${MIGRATE_ROOT}
    export MIGRATE_DATA_DIR=${MIGRATE_ROOT}
    cd ${MIGRATE_ROOT}
    bash upgrade_tool/frame/cloudsop_transfer.sh RMService migrate_data
    if [[ $? -ne 0 ]]
    then
        echo "[`date`] cloudsop upgradetool migrate failed."
        exit 1
    else
        echo "[`date`] cloudsop upgradetool migrate success."
    fi
}


function main(){
    # 设计态或自动驾驶场景，执行InvMirrorService, InvHistoryService迁移，只涉及R版本升级
    InvHistoryService_ip=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep InvHistoryService`
    if [[ ! -z ${InvHistoryService_ip} ]]
    then
        echo "InvHistoryService environment ${InvHistoryService_ip}"
        start_or_stop_app InvMirrorService invmirrorservice stopapp
        start_or_stop_app InvHistoryService invhistoryservice stopapp
        cloudsop_upgradetool_migrate
        start_or_stop_app InvMirrorService invmirrorservice startapp
        start_or_stop_app InvHistoryService invhistoryservice startapp
    fi
}

main $@ >> ${log_file} 2>&1