#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    #修改bgp网卡用途 第二个节点不需要BGP_FLOATIP且BGP_FLOATIP变更为BGPSouthBound
    $PYTHONHOME/bin/python ${EXEC_HOME}/../pyscripts/rollback_bgp_floatip.py.py ${EXEC_HOME}/../one_hop_pre_upgrade/networkinfo_$tenant_name.json
    result=$?
    if [[ "${result}" == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "modify_north_floatip_nodes successfully"
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "modify_north_floatip_nodes failed"
            exit 1
    fi
}

main $@ >> ${log_file} 2>&1