#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){

    # SNMP升级并重启DCNNorthboundCommunicationService
    if [[ ! -f $EXEC_HOME/dcn_northbound_record.flag ]]
    then
        . /opt/oss/manager/bin/engr_profile.sh;${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/snmp_upgrade.py
        result=$?
        if [[ "${result}" == "0" ]]
        then
            echo "successfully" > $EXEC_HOME/dcn_northbound_record.flag
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "snmp upgrade successfully."
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "snmp upgrade failed."
            exit 1
        fi
        /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep -w "DCNNorthboundCommunicationService" | awk '{print $6}'| while read line
        do
            echo "restart DCNNorthboundCommunicationService in $line"
            ssh ossadm@"$line" << remotessh
                /opt/oss/manager/agent/bin/ipmc_adm -cmd restartapp -app "DCNNorthboundCommunicationService"
                exit
remotessh
        done
    fi

}

main $@ >> ${log_file} 2>&1