#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}

function main(){

    is_install_underlay=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep -w "DCNUnderlayService"`
    if [ "${is_install_underlay}X" = "X" ]; then
        echo "DCNUnderlayService is not installed, skip it."
        exit 0
    fi

    # 执行underlay的迁移
    retry_times=8
    cd ${EXEC_HOME}/../plugins/underservice_sql
    for((i=1;i<=${retry_times};i++))
    do
        . /opt/oss/manager/bin/engr_profile.sh; bash migrate_common.sh
        result=$?
        if [[ "${result}" == "0" ]]
        then
            echo "underservice_migrate migrates successfully."
            break
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "underservice_migrate migrates failed, retry_times: ${i}"
            if [[ ${i} -eq ${retry_times} ]]
            then
                exit 1
            fi
            sleep 5
        fi
    done
}

main $@ >> ${log_file} 2>&1